<?php

namespace App\Models\Vendor;

use App\Constants\GlobalConst;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Admin\ParlourList;
use App\Models\ParlourBooking;

class ParlourHasStuff extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    protected $casts = [
        'id'                => 'integer',
        'parlour_list_id'   => 'integer',
        'vendor_id'         => 'integer',
        'stuff_name'        => 'string',
        'address'            => 'string',
        'mobile'            => 'string',
        'image'             => 'string',
        'status'            => 'integer',
    ];
    public function parlour(){
        return $this->belongsTo(ParlourList::class,'parlour_list_id');
    }
    public function parlour_booking(){
        return $this->hasMany(ParlourBooking::class,'stuff_id');
    }

    public function getStringStatusAttribute() {
        $status = $this->status;
        $data = [
            'class' => "",
            'value' => "",
        ];
        if($status == GlobalConst::STATUSASSIGN) {
            $data = [
                'class'     => "badge badge--success",
                'value'     => "Assigned",
            ];
        }
        return (object) $data;
    }
}
