<?php

namespace App\Models\Vendor;

use App\Models\Admin\ParlourList;
use App\Models\ManagerPasswordReset;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Laravel\Passport\HasApiTokens;
use Illuminate\Notifications\Notifiable;


class Manager extends Authenticatable
{
    use HasFactory,Notifiable,HasApiTokens;
    protected $guarded = ["id"];
    protected $appends = ['fullname'];

    protected $casts = [
        'vendor_id'           => 'integer',
        'firstname'           => 'string',
        'lastname'            => 'string',
        'username'            => 'string',
        'email'               => 'string',
        'mobile_code'         => 'string',
        'mobile'              => 'string',
        'full_mobile'         => 'string',
        'password'            => 'string',
        'refferal_user_id'    => 'integer',
        'image'               => 'string',
        'status'              => 'integer',
        'assign_status'       => 'integer',
        'email_verified_at'   => 'datetime',
        'address'             => 'object',
        'email_verified'      => 'integer',
        'sms_verified'        => 'integer',
        'kyc_verified'        => 'integer',
        'ver_code'            => 'integer',
        'ver_code_send_at'    => 'datetime',
        'two_factor_verified' => 'integer',
        'two_factor_status'   => 'integer',
        'device_id'           => 'string',
        'social_type'         => 'string',
        'remember_token'      => 'string',
        'deleted_at'          => 'datetime',
        'created_at'          => 'datetime',
        'updated_at'          => 'datetime',
    ];

    public function passwordResets() {
        return $this->hasMany(ManagerPasswordReset::class,"manager_id");
    }

    public function parlourlist() {
        return $this->hasMany(ParlourList::class,"manager_id");
    }

    public function scopeAuth($q){
        return $q->where('vendor_id',auth()->user()->id);
    }

    public function getFullnameAttribute()
    {
        return $this->firstname . ' ' . $this->lastname;
    }

}
