<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Admin\ParlourList;
use App\Models\Admin\ParlourListHasSchedule;
use App\Models\Admin\PaymentGatewayCurrency;
use Illuminate\Support\Facades\DB;
use App\Models\Admin\PaymentGateway;
use App\Constants\PaymentGatewayConst;
use App\Models\Vendor\ParlourHasStuff;

class ParlourBooking extends Model
{
    use HasFactory;
    protected $guarded  = ['id'];

    protected $casts                    = [
        'id'                            => 'integer',
        'parlour_id'                    => 'integer',
        'stuff_id'                      => 'integer',
        'vendor_id'                     => 'integer',
        'schedule_id'                   => 'integer',
        'user_id'                       => 'integer',
        'payment_gateway_currency_id'   => 'integer',
        'trx_id'                        => 'string',
        'booking_exp_seconds'           => 'integer',
        'date'                          => 'string',
        'payment_method'                => 'string',
        'type'                          => 'string',
        'reject_reason'                 => 'string',
        'payment_currency'              => 'string',
        'slug'                          => 'string',
        'total_charge'                  => 'decimal:8',
        'price'                         => 'decimal:8',
        'payable_price'                 => 'decimal:8',
        'gateway_payable_price'         => 'decimal:8',
        'service'                       => 'object',
        'message'                       => 'string',
        'remark'                        => 'string',
        'serial_number'                 => 'integer',
        'status'                        => 'integer',
        'stuff_assign_status'           => 'integer',
        'reject_reason'                 =>'string'
    ];

    public function scopeAuth($q){
        return $q->where('vendor_id',auth()->user()->id);
    }

    public function schedule(){
        return $this->belongsTo(ParlourListHasSchedule::class,'schedule_id');
    }
    public function parlour(){
        return $this->belongsTo(ParlourList::class,'parlour_id');
    }
    public function stuff()
    {
        return $this->belongsTo(ParlourHasStuff::class,'stuff_id');
    }



    public function user()
    {
        return $this->belongsTo(User::class);
    }


    public function getRouteKeyName()
    {
        return "trx_id";
    }

    public function payment_gateway()
    {
        return $this->belongsTo(PaymentGateway::class);
    }




    public function receiver_info() {
        return $this->belongsTo(User::class,'receiver_id');
    }





    public function getStringStatusAttribute() {
        $status = $this->status;
        $data = [
            'class' => "",
            'value' => "",
        ];
        if($status == PaymentGatewayConst::STATUSSUCCESS) {
            $data = [
                'class'     => "badge badge--success",
                'value'     => "Success",
            ];
        }else if($status == PaymentGatewayConst::STATUSPENDING) {
            $data = [
                'class'     => "badge badge--warning",
                'value'     => "Pending",
            ];
        }else if($status == PaymentGatewayConst::STATUSHOLD) {
            $data = [
                'class'     => "badge badge--warning",
                'value'     => "Hold",
            ];
        }else if($status == PaymentGatewayConst::STATUSREJECTED) {
            $data = [
                'class'     => "badge badge--danger",
                'value'     => "Rejected",
            ];
        }else if($status == PaymentGatewayConst::STATUSWAITING) {
            $data = [
                'class'     => "badge badge--danger",
                'value'     => "Waiting",
            ];
        }

        return (object) $data;
    }



    public function gateway_currency() {
        return $this->belongsTo(PaymentGatewayCurrency::class,'payment_gateway_currency_id');
    }

    public function scopePending($query) {
        return $query->where('status',PaymentGatewayConst::STATUSPENDING);
    }

    public function scopeComplete($query) {
        return $query->where('status',PaymentGatewayConst::STATUSSUCCESS);
    }

    public function scopeReject($query) {
        return $query->where('status',PaymentGatewayConst::STATUSREJECTED);
    }

    public function scopeAddMoney($query) {
        return $query->where('type',PaymentGatewayConst::PAYMENTMETHOD);
    }

    public function scopeChartData($query) {
        return $query->select([
            DB::raw("DATE(created_at) as date"),
            DB::raw('COUNT(*) as total')
        ])
        ->groupBy('date')
        ->pluck('total');
    }

    public function scopeThisMonth($query) {
        return $query->whereBetween('created_at',[now()->startOfMonth(),now()->endOfMonth()]);
    }

    public function scopeThisYear($query) {
        return $query->whereBetween('created_at',[now()->startOfYear(),now()->endOfYear()]);
    }

    public function scopeYearChartData($query) {
        return $query->select([
            DB::raw('sum(total_charge) as total, YEAR(created_at) as year, MONTH(created_at) as month'),
        ])->groupBy('year','month')->pluck('total','month');
    }



    public function scopeSearch($query,$data) {
        return $query->where("trx_id","like","%".$data."%")
                ->orWhere('payment_method',"like","%" . $data . "%")
                ->orderBy('id','desc');;
    }
}
