<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ParlourListHasSchedule extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    protected $casts = [
        'id'                => 'integer',
        'parlour_list_id'   => 'integer',
        'from_time'         => 'string',
        'to_time'           => 'string',
        'max_client'        => 'integer',
        'status'            => 'integer',
    ];
    public function parlour(){
        return $this->belongsTo(ParlourList::class,'parlour_list_id');
    }
}
