<?php

namespace App\Models\Admin;

use App\Constants\GlobalConst;
use App\Models\ParlourBooking;
use App\Models\User\FavoritesSalon;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Vendor\ParlourHasStuff;
use App\Models\Vendor\Vendor;
use App\Models\Vendor\Manager;
use App\Models\Vendor\ParlourImage;

class ParlourList extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    protected $casts = [
        'area_id'                => 'integer',
        'vendor_id'              => 'integer',
        'manager_id'             => 'integer',
        'slug'                   => 'string',
        'name'                   => 'string',
        'experience'             => 'string',
        'speciality'             => 'string',
        'contact'                => 'string',
        'address'                => 'string',
        'off_days'               => 'string',
        'remarks'                => 'string',
        'number_of_dates'        => 'integer',
        'image'                  => 'string',
        'status'                 => 'integer',
        'active_status'          => 'integer',
        'created_at'             => 'date:Y-m-d',
        'updated_at'             => 'date:Y-m-d',
    ];

    public function scopeAuth($q){
        return $q->where('vendor_id',auth()->user()->id);
    }

    public function parlourBooking(){
        return $this->hasMany(ParlourBooking::class,'parlour_id');
    }

    public function schedules(){
        return $this->hasMany(ParlourListHasSchedule::class,'parlour_list_id');
    }
     public function favorites(){
        return $this->hasMany(FavoritesSalon::class,'parlour_id');
    }
     public function parlourImage(){
        return $this->hasMany(ParlourImage::class,'parlour_lists_id');
    }
    public function services(){
        return $this->hasMany(ParlourHasService::class,'parlour_list_id');
    }

    public function area(){
        return $this->belongsTo(Area::class,'area_id');
    }

    public function stuff(){
        return $this->hasMany(ParlourHasStuff::class,'parlour_list_id');
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor::class, 'vendor_id', 'id');
    }

    public function manager()
    {
        return $this->belongsTo(Manager::class, 'manager_id', 'id');
    }


    public function getStringStatusAttribute() {
        $status = $this->status;
        $data = [
            'class' => "",
            'value' => "",
        ];
        if($status == GlobalConst::STATUSSUCCESS) {
            $data = [
                'class'     => "badge badge--success",
                'value'     => "Approved",
            ];
        }else if($status == GlobalConst::STATUSPENDING) {
            $data = [
                'class'     => "badge badge--warning",
                'value'     => "Pending",
            ];
        }else if($status == GlobalConst::STATUSREJECTED) {
            $data = [
                'class'     => "badge badge--danger",
                'value'     => "Rejected",
            ];
        }else if($status == GlobalConst::STATUSDISABLE) {
            $data = [
                'class'     => "badge badge--danger",
                'value'     => "Disabled",
            ];
        }

        return (object) $data;
    }
}
