<?php

namespace App\Http\Middleware\Vendor;

use Closure;
use Illuminate\Http\Request;

class GoogleTwoFactor
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $vendor = auth()->user();
        if($vendor->two_factor_status == true && $vendor->two_factor_verified == false) return google_two_factor_verification_vendor_template($vendor);
        return $next($request);
    }
}
