<?php

namespace App\Http\Controllers\Vendor;

use App\Http\Controllers\Controller;
use App\Models\Admin\ParlourHasService;
use App\Models\Admin\ParlourList;
use Illuminate\Http\Request;

class ServiceSectionController extends Controller
{
    public function index(){
        $page_title = 'Service List';
        $data    = ParlourList::where('vendor_id', auth()->user()->id)->with('parlourBooking')->get();
        return view('vendor.sections.service-section.index', compact('page_title', 'data'));

    }

    public function serviceDetails($parlour_id)
    {
        $page_title = "Service Details";
        $service_data = ParlourHasService::
            where('parlour_list_id', $parlour_id)
        ->orderByDesc('id')
        ->get();

        return view('vendor.sections.service-section.details', compact('page_title', 'service_data'));


    }
}
