<?php

namespace App\Http\Controllers\Vendor;

use Exception;
use App\Http\Controllers\Controller;
use App\Models\Admin\ParlourList;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;
use App\Models\ParlourBooking;
use App\Models\Admin\PaymentGateway;
use App\Models\Vendor\VendorWallet;
use App\Constants\GlobalConst;

class DashboardController extends Controller
{

    public function index()
    {
        $vendor_id      = auth()->user()->id;

        $page_title     = __("Dashboard");
        $complete_data  = [];
        $month_day      = [];

        $start          = strtotime(date('Y-m-01'));
        $end            = strtotime(date('Y-m-t'));

        while ($start <= $end) {
            $start_date = date('Y-m-d', $start);

            $complete = ParlourBooking::where('status', GlobalConst::STATUSSUCCESS)
                ->where('vendor_id', $vendor_id)
                ->whereDate('created_at', $start_date)
                ->count();

            $complete_data[]  = $complete;
            $month_day[] = date('Y-m-d', $start);
            $start = strtotime('+1 day', $start);
        }
        // Chart one
        $chart_one_data = [
            'complete_data'  => $complete_data,
        ];

        $data = [
            'chart_one_data'         => $chart_one_data,
            'month_day'              => $month_day,
        ];

        $salon = ParlourList::auth()->with('services')->get();
     

        $total_salon = $salon->count();
        $total_service = $salon->pluck('services')->flatten()->count();
        $total_online_transactions  = ParlourBooking::auth()->whereNot('payment_method',GlobalConst::CASH_PAYMENT)->with(['parlour','schedule','payment_gateway','user'])->count();
        $vendor_wallet = VendorWallet::where('vendor_id',auth()->user()->id)->first();


        return view('vendor.dashboard', compact(
            "page_title",
            "data",
            'total_salon',
            'vendor_wallet',
            'total_service',
            'total_online_transactions',

        ));
    }

    public function logout(Request $request)
    {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('vendors.login');
    }




    public function deleteAccount(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'target'        => 'required',
        ]);
        $validated = $validator->validate();
        $user = auth()->user();
        try {
            $user->status = 0;
            $user->save();
            Auth::logout();
            return redirect()->route('frontend.index')->with(['success' => ['Your account deleted successfully!']]);
        } catch (Exception $e) {
            return back()->with(['error' => [__('Something went wrong! Please try again')]]);
        }
    }
}
