<?php

namespace App\Http\Controllers\Vendor;

use App\Http\Controllers\Controller;
use App\Models\Admin\ParlourList;
use Illuminate\Http\Request;
use App\Models\ParlourBooking;
use App\Models\Vendor\ParlourHasStuff;

class BookingRequestController extends Controller
{
    public function index(Request $request)
    {
        $page_title = 'Booking Request';
        $data       = ParlourList::where('vendor_id', auth()->user()->id)->with('parlourBooking')->paginate(2);;
        return view('vendor.sections.booking-request.index', compact('page_title', 'data'));
    }

    public function history()
    {

        $vendor_id = auth()->user()->id;
        $booking_data  = ParlourBooking::where('vendor_id', $vendor_id)->orderBYDESC('id')->get();

        return view('vendor.sections.history-section.index', compact('booking_data'));
    }

    public function bookingDetails($booking_id)
    {
        
        $page_title = "Details";
        $booking_data = ParlourBooking::with('parlour', 'schedule')
        ->where('vendor_id', auth()->user()->id)
        ->where('parlour_id', $booking_id)
        ->orderByDesc('id')
        ->paginate(5);

        $parlour_has_stuff  = ParlourHasStuff::where('vendor_id', auth()->user()->id)
        ->get();

        return view('vendor.sections.booking-request.details', compact('page_title', 'booking_data','parlour_has_stuff'));


    }
}
