<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use App\Models\User\FavoritesSalon;
use Illuminate\Http\Request;
use App\Http\Helpers\Response;

class FavoriteSalonController extends Controller
{
    public function index()
    {
        $page_title = __("Favorite Salons");
        $parlour_lists = FavoritesSalon::where('user_id', auth()->user()->id)->with('parlour')->get();
        return view('user.favorites.index', compact('page_title', 'parlour_lists'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'parlour_id' => 'required|exists:parlour_lists,id',
        ]);

        if (!auth()->check()) {
            return Response::error(['error' => [__('Please login to favorite salons')]], null, 401);
        }

        $favorite = FavoritesSalon::updateOrCreate(
            [
                'user_id' => auth()->id(),
                'parlour_id' => $request->parlour_id,
            ],
            [
                'created_at' => now()
            ]
        );
        $wasRecentlyCreated = $favorite->wasRecentlyCreated;

        $message = $wasRecentlyCreated
            ? __('Salon added to favorites!')
            : __('Salon was already in favorites!');

        $success = ['success' => [$message]];
        return Response::success($success, null, 200);
    }

    public function delete(Request $request)
    {
        $parlour_id = $request->parlour_id;

        $fav_parlour = FavoritesSalon::where('parlour_id', $parlour_id)->first();

        $fav_parlour->delete();
         $message =  __('Salon removed form favorites!');
        $success = ['success' => [$message]];
        return Response::success($success, null, 200);
    }
}
