<?php
namespace App\Http\Controllers\User;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\ParlourBooking;
use App\Models\Admin\ParlourList;
use App\Models\Admin\Area;
use App\Constants\GlobalConst;
use App\Models\Admin\BasicSettings;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class DashboardController extends Controller
{
    public function index(BasicSettings $basic_settings)
    {

        $page_title                     = "Dashboard";
        $total_transactions             = ParlourBooking::auth()->with(['parlour','schedule','payment_gateway','user'])->count();
        $total_online_transactions      = ParlourBooking::auth()->whereNot('payment_method',GlobalConst::CASH_PAYMENT)->with(['parlour','schedule','payment_gateway','user'])->count();
        $total_cash_transactions        = ParlourBooking::auth()->where('payment_method',GlobalConst::CASH_PAYMENT)->with(['parlour','schedule','payment_gateway','user'])->count();
        $booking_data                   = ParlourBooking::where('user_id',auth()->id())->with(['parlour','schedule','payment_gateway','user'])
                                         ->orderBYDESC('id')
                                         ->latest()
                                         ->take(3)
                                          ->get();


                            $complete_data  = [];
                            $month_day  = [];

                            $start = strtotime(date('Y-m-01'));
                            $end = strtotime(date('Y-m-t'));

                            while ($start <= $end) {
                                $start_date = date('Y-m-d', $start);

                                $complete = ParlourBooking::where('status', global_const()::STATUSSUCCESS)
                                    ->where('vendor_id', auth()->id())
                                    ->whereDate('created_at', $start_date)
                                    ->count();

                                $complete_data[]  = $complete;
                                $month_day[] = date('Y-m-d', $start);
                                $start = strtotime('+1 day', $start);
                            }
                            // Chart one
                            $chart_one_data = [
                                'complete_data'  => $complete_data,
                            ];

                            $data = [
                                'chart_one_data'         => $chart_one_data,
                                'month_day'              => $month_day,
                            ];

        return view('user.dashboard',compact(
            "page_title",
            'data',
            "booking_data",
            "total_transactions",
            "total_online_transactions",
            "total_cash_transactions",
        ));
    }

    public function logout(Request $request) {
        Auth::logout();
        $request->session()->invalidate();
        $request->session()->regenerateToken();
        return redirect()->route('user.login');
    }

     /**
     * Method for view the find parlour page
     * @return view
     */
    public function findParlour(Request $request)
    {
        $page_title             = "Find Salon";
        $areas                  = Area::where('status', true)->get();
        $parlour_lists          = ParlourList::where('status', true)->where('active_status',GlobalConst::STATUSUNFREEZE)->paginate(6);

        $message                = Session::get('message');
        $validator = Validator::make($request->all(), [
            'area'          => 'nullable',
            'name'          => 'nullable',
        ]);
        if ($validator->fails()) {
            return back()->with(['error' => ['Something went wrong! Please try again.']]);
        }
        if ($request->area && $request->name) {
            $parlour_lists    = ParlourList::where('area_id', $request->area)->where('name', 'like', '%' . $request->name . '%')->get();
        } else if ($request->area) {
            $parlour_lists    = ParlourList::where('area_id', $request->area)->get();
        } else if ($request->name) {
            $parlour_lists    = ParlourList::where('name', 'like', '%' . $request->name . '%')->get();
        }
        $areaString     = $request->area;
        $nameString     = $request->name;
        return view('user.sections.find-parlour.index', compact(
            'page_title',
            'areas',
            'areaString',
            'nameString',
            'parlour_lists',
            'message'
        ));
    }
}
