<?php

namespace App\Http\Controllers\Manager;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\ParlourBooking;
use App\Models\Admin\ParlourList;
use App\Http\Helpers\Response;
use App\Notifications\EmailNotification;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Notification;
use App\Models\Admin\BasicSettings;
use App\Models\User;
use App\Models\Vendor\AdminCharges;
use App\Models\Vendor\ParlourHasStuff;
use App\Models\Vendor\VendorWallet;
use Exception;

class BookingRequestController extends Controller
{
    public function index()
    {
        $page_title         = 'Booking Request';
        $vendor_id           = auth()->user()->vendor_id;
        $parlour_id         = ParlourList::where('manager_id', auth()->id())->value('id');
        $booking_data        = ParlourBooking::with('parlour', 'schedule', 'user')->where('vendor_id', $vendor_id)->where('parlour_id', $parlour_id)->orderBYDESC('id')->get();
        $parlour_id         = ParlourList::where('manager_id', auth()->id())->value('id');
        $parlour_has_stuff  = ParlourHasStuff::where('vendor_id', $vendor_id)
            ->where('parlour_list_id', $parlour_id)
            ->get();

        return view('manager.section.booking-request.index', compact('booking_data', 'parlour_has_stuff', 'page_title'));
    }

    /**
     * Method for update Status for Booking Logs
     * @param $trx_id
     * @param \Illuminate\Http\Request $request
     */
    public function statusUpdate(Request $request, $trx_id)
    {

        $data           = ParlourBooking::with(['parlour', 'schedule', 'payment_gateway'])->where('trx_id', $trx_id)->first();

        if (!$data) return back()->with(['error' =>  ['Data Not Found!']]);
        $validator      = Validator::make($request->all(), [
            'status'    => 'required|integer',
        ]);

        if ($validator->fails()) {
            return Response::error(['error' => $validator->errors()]);
        }
        $validated = $validator->validate();
        $basic_setting = BasicSettings::first();

        $total_charge = $data->total_charge;
        $wallet  = VendorWallet::where('vendor_id', auth()->user()->vendor_id)->first();

        $balance = $wallet->balance;

        try {
            $data->update([
                'status'    => $validated['status'],
            ]);
            $wallet->update([
                'balance'    => $balance - $total_charge,
            ]);


            $user   = User::where('id', $data->user_id)->first();

            if ($basic_setting->email_notification == true) {
                try {
                    Notification::route("mail", $user->email)->notify(new EmailNotification($user, $data, $data->trx_id));
                } catch (Exception $e) {
                }
            }
        } catch (Exception $e) {
            return back()->with(['error' => ['Something went wrong! Please try again.']]);
        }
        return back()->with(['success'  => ['Booking Status Updated Successfully.']]);
    }

    public function remarkAdd(Request $request, $id)
    {
        $parlour = ParlourBooking::find($id);

        try {
            $parlour->update(
                [
                    'notes' => $request->remarks,
                ]
            );
        } catch (Exception $e) {
        }
        return back()->with(['success'  => ['Remarks added to this booking request.']]);
    }
}
