<?php

namespace App\Http\Controllers\Manager;

use App\Http\Controllers\Controller;
use App\Models\Admin\ParlourList;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Admin\BasicSettings;
use Illuminate\Support\Arr;
use App\Models\Vendor\ParlourHasStuff;
use Exception;
use App\Constants\GlobalConst;
use App\Http\Helpers\Response;
use App\Models\Admin\ParlourListHasSchedule;
use App\Models\ParlourBooking;

class AssignStuffController extends Controller
{
    public function index()
    {
        $page_title      = "Stuff";
        $vendor_id = auth()->user()->vendor_id;
        $parlour_id = ParlourList::where('manager_id', auth()->id())->value('id');
        $stuff = ParlourHasStuff::with('parlour','parlour_booking')->where('vendor_id', $vendor_id)
            ->where('parlour_list_id', $parlour_id)
            ->get();

        return view('manager.section.assing-stuff.index',compact('page_title','stuff'));
    }
     /**
     * Method for store parlour list information
     * @param \Illuminate\Http\Request $request
     */
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'parlour_booking_id' => 'required|integer',
            'stuff_name.*'       => 'required|integer',
        ]);

        if ($validator->fails()) {
            return back()->withErrors($validator)->withInput($request->all());
        }

        $validated = $validator->validate();
        $parlour_booking_id = $validated['parlour_booking_id'];

        try {
            ParlourBooking::where('stuff_id', $request->stuff_name)->update([
                'stuff_id'            => null,
                'stuff_assign_status' => 0,
            ]);

            ParlourBooking::where('id', $parlour_booking_id)->update([
                'stuff_id'            => $request->stuff_name,
                'stuff_assign_status' => GlobalConst::STUFFASSIGN,
            ]);

        } catch (Exception $e) {
            return back()->with(['error' => ["Something went wrong. Please try again."]]);
        }

        return redirect()->route('manager.booking.request.index')->with(['success' => ["Stuff Assigned Successfully!"]]);
    }

    public function details($stuff_id)
    {
        $page_title      = "Stuff details";
        $parlour_id      = ParlourList::where('manager_id', auth()->id())->value('id');
        $schedule_id    = ParlourBooking ::where('stuff_id',$stuff_id)->where('parlour_id',$parlour_id)->value('schedule_id');

        $data            = ParlourListHasSchedule::with('parlour')
                        ->where('id', $schedule_id)
                        ->get();
        return view('manager.section.assing-stuff.details',compact('page_title','data'));
    }
}
