<?php

namespace App\Http\Controllers;

use App\Models\ParlourBooking;
use Illuminate\Http\Request;
use Jenssegers\Agent\Facades\Agent;
use Carbon\Carbon;
use PDF;

class GlobalController extends Controller
{

    /**
     * Funtion for get state under a country
     * @param country_id
     * @return json $state list
     */
    public function getStates(Request $request) {
        $request->validate([
            'country_id' => 'required|integer',
        ]);
        $country_id = $request->country_id;
        // Get All States From Country
        $country_states = get_country_states($country_id);
        return response()->json($country_states,200);
    }


    public function getCities(Request $request) {
        $request->validate([
            'state_id' => 'required|integer',
        ]);

        $state_id = $request->state_id;
        $state_cities = get_state_cities($state_id);

        return response()->json($state_cities,200);
     
    }


    public function getCountries(Request $request) {
        $countries = get_all_countries();

        return response()->json($countries,200);
    }


    public function getTimezones(Request $request) {
        $timeZones = get_all_timezones();

        return response()->json($timeZones,200);
    }

    public function setCookie(Request $request){
        $userAgent = $request->header('User-Agent');
        $cookie_status = $request->type;
        if($cookie_status == 'allow'){
            $response_message = __("Cookie Allowed Success");
            $expirationTime = 2147483647; //Maximum Unix timestamp.
        }else{
            $response_message = __("Cookie Declined");
            $expirationTime = Carbon::now()->addHours(24)->timestamp;// Set the expiration time to 24 hours from now.
        }
        $browser = Agent::browser();
        $platform = Agent::platform();
        $ipAddress = $request->ip();
        return response($response_message)->cookie('approval_status', $cookie_status,$expirationTime)
            ->cookie('user_agent', $userAgent,$expirationTime)
            ->cookie('ip_address', $ipAddress,$expirationTime)
            ->cookie('browser', $browser,$expirationTime)
            ->cookie('platform', $platform,$expirationTime);
    }

        /**
     * Download booking details as PDF
     */
    public function downloadPdf($slug)
    {
        
        $data = ParlourBooking::
            with(['parlour', 'schedule', 'payment_gateway'])
            ->where('slug', $slug)
            ->firstOrFail();

        $page_title = "Booking Details";

        // Load the view with data
        $pdf = PDF::loadView('user.sections.my-booking.pdf-details', compact('page_title', 'data'));

        // Download the PDF with a filename
        return $pdf->download('booking-details-' . $data->trx_id . '.pdf');
    }
}
