<?php

namespace App\Http\Controllers\Api\V1\Vendor;

use App\Http\Controllers\Controller;
use App\Constants\GlobalConst;
use App\Models\ParlourBooking;
use App\Http\Helpers\Api\Helpers as ApiResponse;
use App\Models\Admin\ParlourList;
use App\Models\Vendor\VendorWallet;

class DashboardController extends Controller
{
    public function dashboard()
    {
        try {
            $vendor_id = auth()->user()->id;
            $start = strtotime(date('Y-m-01'));
            $end = strtotime(date('Y-m-t'));

            $complete_data = [];
            $month_day = [];

            while ($start <= $end) {
                $start_date = date('Y-m-d', $start);

                $complete = ParlourBooking::where('status', GlobalConst::STATUSSUCCESS)
                    ->where('vendor_id', $vendor_id)
                    ->whereDate('created_at', $start_date)
                    ->count();

                $complete_data[] = $complete;
                $month_day[] = $start_date;
                $start = strtotime('+1 day', $start);
            }

            $chart_one_data = ['complete_data' => $complete_data];
            $data = ['chart_one_data' => $chart_one_data, 'month_day' => $month_day];

            $salon = ParlourList::where('vendor_id', $vendor_id)->with('services')->get();
            $total_salon = $salon->count();
            $total_service = $salon->pluck('services')->flatten()->count();
            $total_online_transactions = ParlourBooking::where('vendor_id', $vendor_id)
                ->whereNot('payment_method', GlobalConst::CASH_PAYMENT)
                ->count();

            $vendor_wallet = VendorWallet::where('vendor_id', $vendor_id)->first();

            if ($total_salon == 0 && $total_service == 0 && $total_online_transactions == 0) {
                $response_data = [
                    'total_salon'                => null,
                    'total_service'              => null,
                    'total_online_transactions'  => null,
                    'vendor_wallet'              => null,
                    'chart_data'                 => null,
                ];
            }

            $response_data = [
                'total_salon' => $total_salon,
                'total_service' => $total_service,
                'total_online_transactions' => $total_online_transactions,
                'vendor_wallet' => $vendor_wallet,
                'chart_data' => $data
            ];

            $message = ['success' => [__('Vendor Dashboard')]];
            return ApiResponse::success($message, $response_data);
        } catch (\Exception $e) {
            $message = ['error' => [__('Something went wrong! Please try again')]];
            return ApiResponse::onlyError($message);
        }
    }



    function notification()
    {
        $vendor_id = auth()->user()->id;
        $notifications  = ParlourBooking::where('vendor_id', $vendor_id)->with('parlour','user')->latest()->take(5)->get();


        $message =  ['success'=>[__('Notification data  fetch successfully!')]];
        $data = [
            'notification_data' => $notifications,
        ];
        return ApiResponse::success($message,$data);
    }
}
