<?php

namespace App\Http\Controllers\Api\V1\Vendor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Http\Helpers\Api\Helpers as ApiResponse;
use App\Models\Admin\ParlourList;
use App\Models\ParlourBooking;
use App\Models\Vendor\ParlourHasStuff;
use Exception;

class BookingRequestController extends Controller
{
    public function index()
    {

        try {

           

            $booking_data = ParlourBooking::with('parlour', 'schedule','user','stuff')
                ->where('vendor_id', auth()->id())
               
                ->orderByDesc('id')
                ->get();

            $parlour_has_stuff = ParlourHasStuff::where('vendor_id', auth()->id())
               
                ->get();


                $image_paths = [
                    'base_url'          => url("/"),
                    'path_location'     => files_asset_path_basename("site-section"),
                    'default_image'     => files_asset_path_basename("default"),
                ];

            $data = [
                'path'          => $image_paths,
                'booking_data' => $booking_data,
                'parlour_has_stuff' => $parlour_has_stuff
            ];

            $message = ['success' => [__('Booking Request  data fetch successfully!')]];
            return ApiResponse::success($message, $data);
        } catch (Exception $e) {

            $message = ['error' => [__('Something went wrong! Please try again')]];
            return ApiResponse::onlyError($message);
        }
    }
}
