<?php

namespace App\Http\Controllers\Api\V1\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\User\FavoritesSalon;
use App\Http\Helpers\Response;

class FavoriteSalonController extends Controller
{
    public function index()
    {
        $parlour_lists = FavoritesSalon::where('user_id', auth()->user()->id)->with('parlour')->get();

        return Response::success('success', $parlour_lists, 200);
    }

    public function store(Request $request)
    {
        $request->validate([
            'parlour_id' => 'required|exists:parlour_lists,id',
        ]);

        if (!auth()->check()) {
            return Response::error(['error' => [__('Please login to favorite salons')]], null, 401);
        }

        $favorite = FavoritesSalon::updateOrCreate(
            [
                'user_id' => auth()->id(),
                'parlour_id' => $request->parlour_id,
            ],
            [
                'created_at' => now()
            ]
        );
        $wasRecentlyCreated = $favorite->wasRecentlyCreated;

        $message = $wasRecentlyCreated
            ? __('Salon added to favorites!')
            : __('Salon was already in favorites!');


        

         return Response::success([__('Salon added to favorites')],[],200);
    }

    public function delete(Request $request)
    {
        $parlour_id = $request->parlour_id;

        if (!$parlour_id) {
            $message = __('No parlour found!');
            return Response::error($message, null, 401);
        }

        $fav_parlour = FavoritesSalon::where('parlour_id', $parlour_id)->first();

        if (!$fav_parlour) {
            $message = __('Salon not found in favorites!');
            return Response::error($message, null, 404);
        }

        $fav_parlour->delete();

          return Response::success([__('Salon removed from favorites')],[],200);
    }
}
