<?php

namespace App\Http\Controllers\Api\V1\Manager\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;


use App\Traits\Vendor\LoggedInVendors;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use App\Http\Helpers\Api\Helpers as ApiResponse;
use App\Models\Vendor\Manager;
use App\Providers\Admin\BasicSettingsProvider;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\Auth;

class AuthController extends Controller
{
    use AuthenticatesUsers;
    protected $basic_settings;

    public function __construct()
    {
        $this->basic_settings = BasicSettingsProvider::get();
    }

    /**
     * Mehtod for vendor login
     * @method POST
     * @param \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Request  Response
     */
    public function login(Request $request){
        $validator = Validator::make($request->all(),[
            'email'    => 'required|max:40',
            'password' => 'required|min:6',
        ]);

        if($validator->fails()){
            $error = ['error' => $validator->errors()->all()];
            return ApiResponse::onlyValidation($error);
        }

        $user = Manager::where('username', trim(strtolower($request->email)))->orWhere('email', $request->email)->first();

        if(!$user){
            $error = ['error' => [__('The credentials does not match')]];
            return ApiResponse::onlyValidation($error);
        }


        $user->save();

        $token = $user->createToken('Auth_token')->accessToken;

        $user_data = [
            'token'         => $token,
            'image_path'    => get_files_public_path('manager-profile'),
            'default_image' => get_files_public_path('default'),
            "base_ur"       => url('/'),
            'user'          => $user
        ];

        if(Hash::check($request->password, $user->password)){
            if($user->status == 0){
                $error = ['error'=>[__('Account Has been Suspended')]];
                return ApiResponse::onlyValidation($error);
            }

            $message = ['success' => [__('Login Successful')]];
            return ApiResponse::success($message,$user_data);
        }else{
            $error = ['error'=>[__('The credentials does not match')]];
            return ApiResponse::onlyError($error);
        }
    }


    protected function guard()
    {
        return Auth::guard("manager_api");
    }
}

